unit Unit8;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, jpeg, GIFImg, Vcl.Imaging.pngimage;

type
  TForm8 = class(TForm)
    Image2: TImage;
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private 錾 }
    FRHandle: THandle;
    FDrawing: Boolean;
    FDraging: Boolean;
    procedure WMEraseBkgnd(var message: TWMEraseBkgnd); message
WM_ERASEBKGND;
    procedure WMEnterSizeMove(var message: TMessage); message
WM_ENTERSIZEMOVE;
    procedure WMExitSizeMove(var message: TMessage); message
WM_EXITSIZEMOVE;
    procedure MakeRGN;
    function DrawRGN(X, Y: Integer): THandle;
    procedure DrawClient;
    procedure DrawWindows(Canvas: TCanvas; X, Y: Integer);




  public
    { Public 錾 }
  end;

var
  Form8: TForm8;

implementation

{$R *.DFM}


procedure TForm8.FormDestroy(Sender: TObject);
begin
  DeleteObject(FRHandle);
end;

procedure TForm8.FormPaint(Sender: TObject);
var
  R1: THandle;
begin
  R1 := DrawRGN(0, 0);
  SelectClipRgn(Canvas.Handle, R1);
  with Canvas do
  begin
    Brush.Color := clRed;
    FillRect(ClientRect);
  end;
  SelectClipRgn(Canvas.Handle, 0);
  DeleteObject(R1);
end;

procedure TForm8.FormResize(Sender: TObject);
begin
  if not FDrawing then
    begin
      FDrawing := True;
      MakeRGN;
      SetWindowRgn(Handle, FRHandle, True);
      if not FDraging then
        begin
          DrawClient;
          SetWindowRgn(Handle, 0, False);
          FormPaint(nil);
        end;
      FDrawing := False;
    end;
end;
procedure TForm8.WMEraseBkgnd(var message: TWMEraseBkgnd);
begin
  message.Result := 1;
  if (not FDraging) and (not FDrawing) then
    begin
      FDrawing := True;
      MakeRGN;
      SetWindowRgn(Handle, FRHandle, True);
      DrawClient;
      SetWindowRgn(Handle, 0, False);
      FormPaint(nil);
      FDrawing := False;
    end;
end;

procedure TForm8.WMEnterSizeMove(var message: TMessage);
begin
  inherited;
  FDraging := True;
  MakeRGN;
  SetWindowRgn(Handle, FRHandle, True);
end;

procedure TForm8.WMExitSizeMove(var message: TMessage);
begin
  inherited;
  DrawClient;
  SetWindowRgn(Handle, 0, False);
  FormPaint(nil);
  FDraging := False;
end;

function TForm8.DrawRGN(X, Y: Integer): THandle;
var
  DC: THandle;
  WorkCanvas: TCanvas;
begin
  DC := CreateCompatibleDC(Canvas.Handle);
  WorkCanvas := TCanvas.Create;
  WorkCanvas.Handle := DC;
  WorkCanvas.Brush := Canvas.Brush;
  WorkCanvas.Pen := Canvas.Pen;
  WorkCanvas.Font := Canvas.Font;
  BeginPath(DC);
  DrawWindows(WorkCanvas, X, Y);
  EndPath(DC);
  Result := PathToRegion(DC);
  WorkCanvas.Free;
  DeleteDC(DC);
end;

procedure TForm8.MakeRGN;
var
  R1, R2, R3: THandle;
  BW, W, H, Y: Integer;
begin
  if FRHandle <> 0 then
    DeleteObject(FRHandle);
  FRHandle := CreateRectRgnIndirect(Rect(0, 0, 0, 0));
  W := Width;
  H := Height;
  R1 := CreateRectRgnIndirect(Rect(0, 0, W, H));
  BW := (W - ClientWidth) shr 1;
  Y := H - ClientHeight - BW;
  R2 := CreateRectRgnIndirect(Rect(BW, Y, W - BW, H - BW));
  CombineRgn(FRHandle, R1, R2, RGN_XOR);
  DeleteObject(R1);
  R3 := DrawRGN(BW, Y);
  CombineRgn(R2, FRHandle, 0, RGN_COPY);
  CombineRgn(FRHandle, R2, R3, RGN_OR);
  DeleteObject(R2);
  DeleteObject(R3);
end;

procedure TForm8.DrawClient;
var
  R1, R2: THandle;
  P: TPoint;
  H: THandle;
  DRect: TRect;
begin
  P := ClientToScreen(Point(0, 0));
  R1 := DrawRGN(0, 0);
  OffsetRgn(R1, P.X, P.Y);
  R2 := CreateRectRgnIndirect(Rect(0, 0, 0, 0));
  H := GetWindow(Handle, GW_HWNDLAST);

  while (H <> Handle) do
  begin
    GetWindowRect(H, DRect);

    CombineRgn(R2, R1, 0, RGN_COPY);

    OffsetRgn(R2, -DRect.Left, -DRect.Top);

    RedrawWindow(H, nil, R2, RDW_UPDATENOW);

    H := GetWindow(H, GW_HWNDPREV);
  end;
  DeleteObject(R2);
  DeleteObject(R1);
end;

procedure TForm8.DrawWindows(Canvas: TCanvas; X, Y: Integer);
begin
  with Canvas do
  begin
    Brush.Style := bsClear;
    TextOut(X, Y, '.');
  end;
end;

end.
